---
Examen - Sécurité des Applications
Author:
- Thibaut HENIN
- Corinne HENIN
- INSA Centre Val de Loire
Date: 2019-2020
---

# Contexte et mission

La société _Speed-e-Devs_ est un éditeur de logiciel web et compte pénétrer le marché des CMS et autres moteurs de blogs.

L'année dernière, elle a fait appel à des ingénieurs spécialistes de la sécurité des applications pour auditer le code de son application. Des vulnérabilités ont été découvertes et ont fait l'objet de recommandations. Suite à ces dernières, l'équipe de _Recherche & Développement_ a produit une nouvelle version du moteur de blog.

Avant sa mise sur le marché, _Speed-e-Devs_ vous confie ce nouvel audit du code source de son application. Il vous est donc demandé de lire le code source fourni à la recherche des vulnérabilités présentes. Pour chaque vulnérabilité trouvée, vous devrez préciser les éléments suivants :

* Les fichiers et ligne de code concernées&nbsp;;
* Des indications pour exploiter la vulnérabilité&nbsp;;
* Les conséquences d'une exploitation&nbsp;;
* Des indications sur la manière de la corriger.

# Structure de l'application

L'application est développée principalement en `PHP` pour la gestion des requêtes web, en `SQL` pour la persistance des données et en `C` pour l'implémentation des primitives cryptographiques.

L'ensemble du projet doit être déployé dans le répertoire `/var/www/`. Les fichiers sont organisés en sous-répertoires comme suit&nbsp;:

* `classes` contient le code `PHP` orienté objet, réparti en quatre _namespaces_&nbsp;:
  * `Dal` (Database Access Layer) pour les accès à la base de donnée,
  * `Model` pour le code _métier_ et la description des objets,
  * `Utils` pour les classes fournissant des services divers,
  * `View` pour la construction des pages web.
* `html` contient le code php disponible au travers du Web, c'est ici que pointe de _DocumentRoot_ de l'application. Deux répertoires (`posts` et `users`) permettent d'organiser les services disponibles aux utilisateurs.
* `mysql` contient les scripts de création de la base de donnée.

Le fichier `vernam.c` disponible à la racine du projet doit être compilé pour fournir un exécutable `vernam`.
